// demo: CAN-BUS Shield, send data
#include <mcp_can.h>
#include <SPI.h>

MCP_CAN CAN0(10);                                      // Set CS to pin 10

void setup()
{
  Serial.begin(115200);
  // init can bus, baudrate: 500k
  if(CAN0.begin(CAN_50KBPS) == CAN_OK) Serial.print("can init ok!!\r\n");
  else Serial.print("Can init fail!!\r\n");
}
byte myArray160[] = {0x33,0x03,0x50,0xF5,0xE0,0x02,0x28,0x44,0x33,0x23,0x51,0xF1,0xE0,
 01,0x88,0x09,0x20,0x11,0x10,0x13,0x01,0x88,0x09,0x24,0x11,0x10,0x13,01,0x88,0x05,0x28,0x05,0x90,
 0xff,0xff,0xaf,0xaf,0xaf,0xaf,0xf0,0xa0,10,10,10,0xfa,0xfa,0xfa,0x44}; 
 
unsigned char send0[7] = {0x06, 0x50, 0x60, 0x00, 0x32, 0x01, 0xF4};
unsigned char send1[8] = {0x33, 0x03, 0x50, 0xF5, 0xE0, 0x02, 0x28, 0x44};
unsigned char send2[8] = {0x33, 0x07, 0x51, 0xF1, 0xE0, 0xFF, 0xFF, 0xC0};
unsigned char send3[4] = {0x9B, 0x05, 0x82, 0x44};
unsigned char send4[7] = {0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char send5[3] = {0x33, 0xF1, 0x50};
unsigned char send6[8] = {0x33, 0x07, 0x51, 0xF1, 0xE0, 0xFF, 0xFF, 0xC0};
unsigned char send7[2] = {0x9B, 0x05};

void loop()
{
  // send data:  id = 0x00, standrad flame, data len = 8, stmp: data buf
  CAN0.sendMsgBuf(0x7C0, 0, 7, send0);  
  delay(100);                       // send data per 100ms
  CAN0.sendMsgBuf(0x7C0, 0, 8, send1);  
  delay(100);
  CAN0.sendMsgBuf(0x7C0, 0, 8, send2);  
  delay(100);
  CAN0.sendMsgBuf(0x7C0, 0, 4, send3); 
  delay(500);
  CAN0.sendMsgBuf(0x638, 0, 7, send4);  
  delay(100);                       // send data per 100ms
  CAN0.sendMsgBuf(0x7B0, 0, 3, send5);  
  delay(100);
  CAN0.sendMsgBuf(0x2A0, 0, 8, send6);  
  delay(100);
  CAN0.sendMsgBuf(0x7B0, 0, 2, send7); 
  delay(500);
}

/*********************************************************************************************************
  END FILE
*********************************************************************************************************/
