/*
 * FLASHER.ROM.CMD  by mira308sw
 *
 * Modified update script.
 * This script search for other *.CMD, ask the user, and run it.
 * Made for Connectnav navigation system for Alfa Romeo cars
 *
 * v 01.00: 05/06/2016  first release
 */


#define DEF_CMD_DIR         "/CMD"

/*** TYPES ***/

typedef int  STATUS;
typedef int  BOOL;
typedef void *MODULE_ID;


/*** CONSTANTS ***/

#define YES      (1)
#define NO       (0)
#define OK       (0)
#define ERROR    (-1)
#define SKIP     (1)
#define NULL     (void*) 0
#define FALSE	 0

#define LOAD_NO_SYMBOLS         2
#define LOAD_LOCAL_SYMBOLS      4
#define LOAD_GLOBAL_SYMBOLS     8
#define LOAD_ALL_SYMBOLS       12

#define BUILTINS_FILE_NORMAL  "BUILTINS.OUT"


/*** EXTERN FUNCTION DEFINITIONS ***/

MODULE_ID	LoadAndExecuteFile	( char* p_root,char* p_file_name,int p_ld_symb,int p_invalid,unsigned int p_delay );
STATUS		ShowQuestionScreen	( char* text, int* answer );
STATUS		ShowBargraph		( void );
STATUS		StepBargraph		( char* text, int index );
int			EiC_ExeFile			( int argc, char **argv );

int			UPGSearchFile       ( char* Filename, char *RootDir, char *Param );
STATUS		UPGGetSearchResult  ( int index , char *SearchResult );

STATUS	strcpy	( char* target, char* source );
STATUS	strcat	( char* target, char* source );
int		strcmp	( char* str1, char* str2 );
char*   strrchr	( char* target, char c );

void   SetRebootAfterScript	( int truefalse );

int main ( int argc, char **argv )
{
  char  l_sCmd[256];
  char  l_sText[256];
  char *l_pArgv[4];
  int   l_iAnsw;
  int   l_nFile;
  int   l_i;

  l_pArgv[0] = l_sCmd;
  l_pArgv[1] = argv[1];
  l_pArgv[2] = argv[2];
  l_pArgv[3] = NULL;

  SetRebootAfterScript( FALSE );
  
  // Builtins loading
  if ( NULL==LoadAndExecuteFile( argv[1],BUILTINS_FILE_NORMAL,LOAD_GLOBAL_SYMBOLS,ERROR,0 ) )
    ShowQuestionScreen( "Error loading " BUILTINS_FILE_NORMAL, &l_iAnsw );
  else
  {
    strcpy( l_sCmd,argv[1] );
    strcat( l_sCmd,DEF_CMD_DIR );
    ShowBargraph();
    StepBargraph( "Search for CMD",0 );
    l_nFile=UPGSearchFile( "*.CMD",l_sCmd,NULL );
    if( !l_nFile )
      ShowQuestionScreen( "No *.cmd files found!", &l_iAnsw );

    for( l_i=0 ; l_i<l_nFile ; l_i++ )
    {
      if( UPGGetSearchResult( l_i,l_sCmd )!=ERROR )
      {
        if( strcmp( l_sCmd,argv[0] )==0 )
          continue;
        if( l_nFile==1 )
           l_iAnsw=YES;
        else
        {
          strcpy( l_sText,"Run " );
          strcat( l_sText,strrchr( l_sCmd,'/' )+1 );
          strcat( l_sText," ?" );
          ShowQuestionScreen( l_sText, &l_iAnsw );
        }
        if( l_iAnsw==YES )
        {
          EiC_ExeFile( 3,l_pArgv );
          break;
        }
      }
    }
  }
  return OK;
}
